//
//  MCMainWindowController.h
//  MCApplication
//
//  Created by Ali Lalani on 8/17/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCWindowController.h"
#import "MCMenuManagerSupportProtocol.h"
#import "MCDisplayStateProtocol.h"
#import "MCMainWindowCanvas.h"

//#import <MCFoundation/MCSourceList.h>

#define BookmarkBarAnimationInterval 1.0 / 60
#define BookmarkBarAnimationDuration 0.2

@class MCMainWindowBookmarkBar,MCArrayController,MCSplitView,MCBackForwardHistory;
@class MCHistoryItem;

extern float MCMainWindowBookmarkBarHeight;

@interface MCMainWindowController : MCWindowController <MCDisplayState,MCMenuManagerSupport>{
	// display state
	NSMutableDictionary *displayState;
	id displayStateDelegate;
	
	float mainViewLeftMargin;
	float mainViewRightMargin;
	float mainViewTopMargin;
	float mainViewBottomMargin;
	
	NSMutableDictionary *mainViews;
	NSView <MCMainWindowCanvas>*selectedMainView;

	MCMainWindowBookmarkBar *bookmarkBar;
	
	NSArray *sourceLists;

	IBOutlet MCSplitView *splitView;
	IBOutlet NSView *mainContentView; // where the main stuff is
	IBOutlet id sourceListView; // the stuff on the left of the split
	IBOutlet NSView *progressView; // contains the progress indicator and progress field
	
	BOOL saveSplitSizes; // whether or not to store split view sizes in the user defaults
	BOOL suspendSplitProportionWrite; // when this is yes, won't write split proportions to the display state
	
	BOOL selectedSourceListNewDisplayState;
	
	MCBackForwardHistory *history;
}
- (NSView *)setupMainViewForIdentifier:(NSString *)anIdentifier;
- (void)setupSplitViewSizes;
- (NSRect)calculatedMainViewRect;
- (NSRect)calculatedMainContentViewRect;
- (NSRect)calculatedBookmarkBarRect;
- (NSRect)calculatedMainViewRectWithoutBookmarkBar;
- (NSRect)calculatedMainViewRectWithBookmarkBar;

- (void)setupProgressView;

- (void)removeSourceListView;
- (void)addSourceListView;

- (IBAction)newSourceList:(id)sender;
- (IBAction)newSmartList:(id)sender;

- (IBAction)refresh:(id)sender;
- (IBAction)toggleSourceListViewVisible:(id)sender;
- (IBAction)toggleBookmarkBar:(id)sender;

- (IBAction)newListFromColumnsLayout:(id)sender;

- (void)addBookmarkBarWithAnimation:(BOOL)flag;
- (void)addBookmarkBar;
- (void)removeBookmarkBar;
//- (void)syncNavigatorToggleImage;

- (void)selectedMainViewWillShowObject:(id)anObj;
//- (void)selectSourceList:(id <MCSourceList>)aList;

- (void)goToHistoryItem:(MCHistoryItem *)anItem;

- (IBAction)historyBrowserBack:(id)sender;
- (IBAction)historyBrowserForward:(id)sender;

- (NSString *)sourceListPasteboardType;

// The list and detail menus should only display when a stack view is the selected main view, the app delegate will be asking us about this
- (BOOL)shouldDisplayListAndDetailMenus;
- (void)rebuildViewListMenu:(NSMenu *)menu;
- (void)rebuildViewDetailMenu:(NSMenu *)menu;

/////////////// NOTIFICATIONS /////////////////////
//- (void)addedMajorObject:(NSNotification *)notif;

///////////////// ACCESSORS ///////////////////////
- (NSMutableDictionary *)mainViews;
- (void)setMainViews:(NSMutableDictionary *)aMainViews;

- (float)mainViewLeftMargin;
- (void)setMainViewLeftMargin:(float)aMainViewLeftMargin;

- (float)mainViewRightMargin;
- (void)setMainViewRightMargin:(float)aMainViewRightMargin;

- (float)mainViewTopMargin;
- (void)setMainViewTopMargin:(float)aMainViewTopMargin;

- (float)mainViewBottomMargin;
- (void)setMainViewBottomMargin:(float)aMainViewBottomMargin;

- (NSView <MCMainWindowCanvas>*)selectedMainView;
- (void)setSelectedMainView:(NSView <MCMainWindowCanvas>*)aSelectedMainView;

- (MCMainWindowBookmarkBar *)bookmarkBar;
- (void)setBookmarkBar:(MCMainWindowBookmarkBar *)aBookmarkBar;

- (NSArray *)sourceLists;
- (void)setSourceLists:(NSArray *)aSourceLists;

- (NSView *)mainContentView;

- (void)sourceListsSelected:(NSNotification *)notif;

// this will ask the defaults for the default group identifier, then ask the source list manager for the default source list
// for that identifier, and then select it.
- (void)selectDefaultSourceList;

- (NSArray *)resultsPaneSelectedObjects; // If there's a selection in a results pane on screen, this returns those objects

#pragma mark FirstResponder
- (IBAction)createNewObject:(id)sender;
- (IBAction)changeResultsPaneMode:(id)sender;

#pragma mark History
- (IBAction)historyBack:(id)sender;
- (IBAction)historyForward:(id)sender;
- (MCBackForwardHistory *)history;
- (void)setHistory:(MCBackForwardHistory *)aHistory;


#pragma mark DisplayState
// some methods that will execute writing a particular attribute to the display state
// WINDOW FRAME
- (void)writeFrameToDisplayState;
- (void)readFrameFromDisplayState;

// SOURCE LIST VIEW VISIBILITY
- (void)writeSourceListViewVisibleToDisplayState;
- (void)readSourceListViewVisibleFromDisplayState;

// SPLIT VIEW PROPORTIONS
- (void)writeSplitProportionsToDisplayState;
- (void)readSplitProportionsFromDisplayState;

// BOOKMARK BAR VISIBILITY
- (void)writeBookmarkBarVisibleToDisplayState;
- (void)readBookmarkBarVisibleFromDisplayState;

// SOURCE LIST SELECTION
- (void)writeSourceListSelectionToDisplayState;
- (void)readSourceListSelectionFromDisplayState;
@end
